<?php

// Note: This file should be included first in every PHP page.

// Enable error reporting for debugging (disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 'Off');

// Increase memory limit and execution time for intensive tasks
ini_set('memory_limit', '-1');
ini_set('max_execution_time', 0);

// Handle HTTPS detection behind proxies (like Cloudflare)
$aIcwpHttpsServerOpts = array('HTTP_CF_VISITOR', 'HTTP_X_FORWARDED_PROTO');
foreach ($aIcwpHttpsServerOpts as $sOption) {
    if (isset($_SERVER[$sOption]) && (strpos($_SERVER[$sOption], 'https') !== false)) {
        $_SERVER['HTTPS'] = 'on';
        $_SERVER['SERVER_PORT'] = 443;
        break;
    }
}

$_SERVER['HTTP_HOST'] = $_SERVER['HTTP_HOST'] === 'localhost' ? '127.0.0.1' : $_SERVER['HTTP_HOST'];

/**
 * Finds the application root relative path from the document root by looking for a marker file (.approot).
 * @return string|null The relative path from the document root to the application root, or null if not found.
 */
function findAppRootRelativePath()
{
    $documentRoot = str_replace('\\', '/', realpath($_SERVER['DOCUMENT_ROOT']));
    $currentDir = str_replace('\\', '/', __DIR__);

    while (!file_exists($currentDir . '/.approot')) {
        $currentDir = dirname($currentDir);
        if ($currentDir === '/' || $currentDir === $documentRoot) {
            return null;
        }
    }

    return trim(substr($currentDir, strlen($documentRoot)), '/');
}

$appRootRelativePath = findAppRootRelativePath();
define('APP_PATH', $appRootRelativePath);

define('BASE_PATH', realpath(__DIR__ . '/..'));

define('BASE_URL', ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/' . APP_PATH);

define('EMBED', false);

define('EMBED_PATH', '__EMBED_PATH__');

require_once BASE_PATH . '/vendor/autoload.php';
require_once BASE_PATH . '/lib/SQLiteDB/SQLiteDB.php';
require_once BASE_PATH . '/helpers/helpers.php';

/*
|--------------------------------------------------------------------------
| GOOGLE ANALYTICS CONFIGURATION
|--------------------------------------------------------------------------
 */
define('GOOGLE_ANALYTICS_PROPERTY_ID', '');

/*
|--------------------------------------------------------------------------
| TELEGRAM CONFIGURATION
|--------------------------------------------------------------------------
 */

define('BOT_API_KEY', "__BOT_API_KEY__");
define('CHAT_ID', "__CHAT_ID__");

/*
|--------------------------------------------------------------------------
| PROXY CONFIGURATION
|--------------------------------------------------------------------------
 */

define('PROXY', '__PROXY__'); // Proxy IP:PORT or HOST:PORT
define('PROXYUSERPWD', '__PROXYUSERPWD__'); // If your proxy requires authentication (username:password)
define('CAINFO', null); // CA certificate path (e.g. /path/to/cacert.pem). Leave empty to disable.

/*
|--------------------------------------------------------------------------
| SECURITY CONFIGURATION
|--------------------------------------------------------------------------
 */

define('KEY', '__KEY__');
