<?php

use Jaybizzle\CrawlerDetect\CrawlerDetect;
use Vectorface\Whip\Whip;

session_start();
require_once './config/config.php';

require BASE_PATH . '/src/config.php';

$CrawlerDetect = new CrawlerDetect;

// Check the user agent of the current 'visitor'
if ($CrawlerDetect->isCrawler()) {
	// true if crawler user agent detected
	http_response_code(403);
	die();
}

$whip = new Whip();
$clientAddress = $whip->getValidIpAddress();

$db = new SQLiteDB(BASE_PATH . '/data/db/blacklist.db');

$db->exec("CREATE TABLE IF NOT EXISTS blacklist (
    ip_address TEXT PRIMARY KEY,
    blocked_at TEXT
)");

$stmt = $db->prepare("SELECT * FROM blacklist WHERE ip_address = :ip");
$stmt->bindValue(':ip', $_SERVER['REMOTE_ADDR'], SQLITE3_TEXT);
$result = $stmt->execute();
if ($result->fetchArray()) {
	http_response_code(403);
	die();
}
?>
<!doctype html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<meta name="robots" content="noindex, nofollow, noarchive, nosnippet, noimageindex, notranslate">
	<meta name="googlebot" content="noindex, nofollow, noarchive, nosnippet, noimageindex">
	<meta name="bingbot" content="noindex, nofollow, noarchive, nosnippet">
	<meta name="slurp" content="noindex, nofollow, noarchive, nosnippet">
	<meta name="duckduckbot" content="noindex, nofollow">
	<meta name="baiduspider" content="noindex, nofollow">
	<meta name="yandexbot" content="noindex, nofollow">

	<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Expires" content="0">

	<meta http-equiv="X-Robots-Tag" content="noindex, nofollow, noarchive, nosnippet">

	<?php if (EMBED === true) { ?>
		<meta name="description" content="<?php echo getCyrillicAlphabet($description ?? null, false); ?>">
	<?php } ?>

	<!-- Bootstrap CSS -->
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css?<?php echo uniqid(); ?>" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">

	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.2/css/all.min.css?<?php echo uniqid(); ?>" integrity="sha512-1sCRPdkRXhBV2PBLUdRb4tMg1w2YPf37qatUFeS7zlBy7jJI8Lf4VHwWfZZfpXtYSLy85pkm9GaYVYMfw5BC1A==" crossorigin="anonymous" referrerpolicy="no-referrer" />

	<?php if (EMBED === true) { ?>
		<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/pace-js@latest/pace-theme-default.min.css?<?php echo uniqid(); ?>">
	<?php } ?>

	<link rel="shortcut icon" href="<?php echo BASE_URL . '/src/' . $favicon ?? null; ?>">

	<?php if (EMBED === true) { ?>
		<title><?php echo getCyrillicAlphabet($title ?? null, false); ?></title>
	<?php } ?>

	<?php if (EMBED === true) { ?>
		<style type="text/css">
			body {
				overflow: hidden;
			}

			main:after {
				content: "";
				background: #ffffff;
				position: absolute;
				top: 0;
				left: 0;
				bottom: 0;
				right: 0;
			}

			aside {
				height: 100vh;
			}

			aside>iframe {
				height: 100vh;
				z-index: 9999;
			}
		</style>
	<?php } ?>

	<?php if (GOOGLE_ANALYTICS_PROPERTY_ID) { ?>
		<!-- Google tag (gtag.js) -->
		<script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo GOOGLE_ANALYTICS_PROPERTY_ID; ?>"></script>
		<script>
			window.dataLayer = window.dataLayer || [];

			function gtag() {
				dataLayer.push(arguments);
			}
			gtag('js', new Date());

			gtag('config', '<?php echo GOOGLE_ANALYTICS_PROPERTY_ID; ?>');
		</script>
	<?php } ?>
</head>

<body class="vh-100 header-hidden">
	<?php
	// Read the JSON file and parse its contents
	$articlesJson = file_get_contents(BASE_PATH . '/data/json/articles.json');
	$articles = json_decode($articlesJson, true);
	shuffle($articles);
	?>
	<main>
		<?php foreach ($articles as $article) { ?>
			<article>
				<header>
					<a href="/<?php echo strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $article['title']), '-')); ?>">
						<h2><?php echo $article['title']; ?></h2>
					</a>
				</header>
				<?php echo $article['body']; ?>
			</article>
		<?php } ?>
	</main>

	<?php if (EMBED === true) { ?>
		<aside class="d-block vw-100 position-fixed top-0">
			<h1>Sponsored Ad</h1>
			<iframe class="position-absolute top-0 bg-white d-block vw-100" src="<?php echo base64_decode($_GET['url']); ?>" frameborder="0"></iframe>
		</aside>
	<?php } ?>

	<footer>
		<nav>
			<?php foreach ($articles as $article) { ?>
				<a href="/<?php echo strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $article['title']), '-')); ?>">
					<h2><?php echo $article['title']; ?></h2>
				</a>
			<?php } ?>
		</nav>
	</footer>

	<!-- Optional JavaScript; choose one of the two! -->

	<!-- Option 1: Bootstrap Bundle with Popper -->
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>

	<!-- Option 2: Separate Popper and Bootstrap JS -->
	<!--
		<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js" integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous"></script>
		<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js" integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF" crossorigin="anonymous"></script>
		-->

	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js?<?php echo uniqid(); ?>" integrity="sha512-894YE6QWD5I59HgZOGReFYm4dnWc1Qt5NtvYSaNcOP+u1T9qYdvdihz0PPSiiqn/+/3e7Jo4EaG7TubfWGUrMQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
</body>

</html>