<?php

use Jaybizzle\CrawlerDetect\CrawlerDetect;

require_once './config/config.php';

$CrawlerDetect = new CrawlerDetect;

// Check the user agent of the current 'visitor'
if ($CrawlerDetect->isCrawler()) {
    // true if crawler user agent detected
    http_response_code(403);
    die();
}

if (!isset($_GET['key']) || isset($_GET['key']) && $_GET['key'] != KEY) {
    http_response_code(403);
    die();
}

// Path to your configuration file
$configPath = './config/config.php';

// Read the contents of the file
$configContents = file_get_contents($configPath);

$isEmbedEnabled = strpos($configContents, "define('EMBED', true);") !== false;

// Handle enable/disable actions
if (isset($_GET['action'])) {
    if ($_GET['action'] === 'enable' && !$isEmbedEnabled) {
        $configContents = str_replace("define('EMBED', false);", "define('EMBED', true);", $configContents);
        file_put_contents($configPath, $configContents);
    } elseif ($_GET['action'] === 'disable' && $isEmbedEnabled) {
        $configContents = str_replace("define('EMBED', true);", "define('EMBED', false);", $configContents);
        file_put_contents($configPath, $configContents);
    }

    header("Location: status.php?key=" . KEY);
    die();
} else {
    $message = $isEmbedEnabled ? "EMBED is currently enabled." : "EMBED is currently disabled.";
    $alertClass = $isEmbedEnabled ? "alert-success" : "alert-danger";
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EMBED Status</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="#">Admin Panel</a>
            <div class="navbar-nav">
                <a class="nav-link" href="visitors.php?key=<?php echo KEY; ?>">Visitors</a>
                <a class="nav-link" href="blacklist.php?key=<?php echo KEY; ?>">Blacklist</a>
                <a class="nav-link active" href="status.php?key=<?php echo KEY; ?>">Status</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header text-center">
                        <h3>EMBED Status</h3>
                    </div>
                    <div class="card-body text-center">
                        <div class="alert <?= $alertClass ?>" role="alert">
                            <strong><?= $message ?></strong>
                        </div>
                        <div class="mt-3">
                            <?php if ($isEmbedEnabled): ?>
                                <a href="status.php?key=<?= KEY ?>&action=disable" class="btn btn-danger">Disable EMBED</a>
                            <?php else: ?>
                                <a href="status.php?key=<?= KEY ?>&action=enable" class="btn btn-success">Enable EMBED</a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>